using Server;
using System;
using Server.Items;
using Server.Gumps;

namespace Server.Mobiles
{
	//[CorpseName( "a cu sidhe corpse" )]
	public class CuSidhe : BaseMount
	{
		private DateTime m_HealDelay = DateTime.Now;
      
      public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.BleedAttack;
		}
      
      [Constructable]
		public CuSidhe() : this( "a cu sidhe" )
		{
		}
		
		[Constructable]
		public CuSidhe( string name ) : base( name, 277, 16017, AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{			
			double chance = Utility.RandomDouble() * 23301;
			
			if ( chance <= 1 )
				Hue = 0x489;
			else if ( chance < 50 )
				Hue = Utility.RandomList( 0x657, 0x515, 0x4B1, 0x481, 0x480, 0x455 );
			else if ( chance < 500 )
				Hue = Utility.RandomList( 0x97A, 0x978, 0x901, 0x8AC, 0x5A7, 0x527 ); 
		
			SetStr( 1201, 1225 );
			SetDex( 151, 170 );
			SetInt( 251, 282 );

			SetHits( 1010, 1170 );
			SetMana( 60, 65 );//from Hiryu
			SetStam( 170, 270 );//from hiryu

			SetDamage( 22, 28 );//hiryu damage
			
			SetDamageType( ResistanceType.Physical, 0 );
			SetDamageType( ResistanceType.Cold, 50 );
			SetDamageType( ResistanceType.Energy, 50 );
			
			SetResistance( ResistanceType.Physical, 45, 55 );//used 5 over and 5 under what stratics posted
			SetResistance( ResistanceType.Fire, 25, 35 );
			SetResistance( ResistanceType.Cold, 65, 75 );
			SetResistance( ResistanceType.Poison, 25, 35 );
			SetResistance( ResistanceType.Energy, 65, 75 );

			SetSkill( SkillName.Wrestling, 90.1, 96.8 );
			SetSkill( SkillName.Tactics, 90.3, 99.3 );
			SetSkill( SkillName.MagicResist, 75.3, 90.0 );
			SetSkill( SkillName.Anatomy, 65.5, 69.4 );
			SetSkill( SkillName.Healing, 72.2, 98.9 );
			SetSkill( SkillName.AnimalLore, 65.5, 69.4 );
			SetSkill( SkillName.Veterinary, 72.2, 98.9 );
			
			Tamable = true;
			ControlSlots = 3;
			MinTameSkill = 101.1;					
			
         Fame = 9000;
			Karma = -9000;

			VirtualArmor = 70;
		
			if ( Utility.RandomDouble() < 0.2 )
				PackItem( new TreasureMap( 5, Map.Trammel ) );
		
			PackGold( 300, 500 );
		}	
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosFilthyRich );
		}	
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( from.Race != Race.Elf && from == ControlMaster && from.AccessLevel == AccessLevel.Player )
			{
				Item pads = from.FindItemOnLayer( Layer.Shoes );
				
				if ( pads is PadsOfTheCuSidhe )
					from.SendMessage( "Tve boty ti dovoluji osedlat Cu Sidhe", null, 0x3B2 );
				else
				{
					from.SendLocalizedMessage( 1072203 ); // Only Elves may use this.
					
					return;
				}
			}
			
			base.OnDoubleClick( from );
		}
		
		public override void OnThink() // TODO: Please make sure, if you got Bloody bandages, that CuSidhe can NOT get them.
		{
			if ( DateTime.Now > m_HealDelay )
			{
				m_HealDelay = DateTime.Now + TimeSpan.FromSeconds( Ability.UseBandage( this, true ) );
			}
			base.OnThink();
		}
		
		public override double GetControlChance( Mobile m )
		{
		  	if ( m.Skills[SkillName.AnimalTaming].Base < 93.0 )
		   {
		      m.SendMessage( "Nedokazes ovladat toto stvoreni." );
		     	return 0;
		   }
			else
			{
				return 1.0;
			}				
		}
		
// 		public override bool CanHeal{ get{ return true; } }
// 		public override bool CanHealOwner{ get{ return true; } }
		public override FoodType FavoriteFood{ get{ return FoodType.Meat; } }
		public override bool CanAngerOnTame{ get { return true; } }
		public override bool StatLossAfterTame{ get{ return true; } }
		public override int Hides{ get{ return 10; } }	
		public override int Meat{ get{ return 3; } }	
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public CuSidhe( Serial serial ) : base( serial )
		{
		}
		
		public override int GetIdleSound() { return 0x577; }
		public override int GetAttackSound() { return 0x576; }
		public override int GetAngerSound() { return 0x578; }
		public override int GetHurtSound() { return 0x576; }
		public override int GetDeathSound()	{ return 0x579; }

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
